<?php
require_once 'includes/config.php';
require_once 'includes/utils.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Successful - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
    <header>
        <div class="container">
            <h1><?= SITE_NAME ?></h1>
            <nav>
                <a href="/">Home</a>
            </nav>
        </div>
    </header>

    <main class="container">
        <div class="product-detail" style="max-width: 800px; margin: 3rem auto; text-align: center;">
            <div style="font-size: 80px; color: #4CAF50; margin-bottom: 2rem;">
                ✓
            </div>
            
            <h1 style="color: #4CAF50; margin-bottom: 1rem;">Payment Successful!</h1>
            
            <div class="alert alert-success" style="text-align: left;">
                <p><strong>Thank you for your purchase!</strong></p>
                <p>Your order has been processed successfully.</p>
            </div>
            
            <div style="background: #f9f9f9; padding: 2rem; border-radius: 10px; text-align: left; margin: 2rem 0;">
                <h3>📧 What's Next?</h3>
                <ol style="padding-left: 1.5rem; margin-top: 1rem;">
                    <li style="margin-bottom: 0.8rem;">Check your email inbox (and spam folder)</li>
                    <li style="margin-bottom: 0.8rem;">You'll receive download links and password</li>
                    <li style="margin-bottom: 0.8rem;">Download all file parts</li>
                    <li style="margin-bottom: 0.8rem;">Extract using WinRAR/7-Zip with the password</li>
                    <li style="margin-bottom: 0.8rem;">Enjoy your digital assets!</li>
                </ol>
            </div>
            
            <div class="alert alert-info" style="text-align: left;">
                <p><strong>Need Help?</strong></p>
                <p>If you don't receive the email within 10 minutes, please contact us at <?= ADMIN_EMAIL ?></p>
            </div>
            
            <div style="margin-top: 2rem;">
                <a href="/" class="btn btn-large btn-primary">← Browse More Products</a>
            </div>
        </div>
    </main>

    <footer>
        <div class="container">
            <p>&copy; <?= date('Y') ?> <?= SITE_NAME ?>. All rights reserved.</p>
        </div>
    </footer>
</body>
</html>
