<?php
// Load environment variables
function loadEnv($path) {
    if (!file_exists($path)) {
        return;
    }
    
    $lines = file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0) continue;
        
        list($name, $value) = explode('=', $line, 2);
        $name = trim($name);
        $value = trim($value);
        
        if (!array_key_exists($name, $_ENV)) {
            $_ENV[$name] = $value;
        }
    }
}

loadEnv(__DIR__ . '/../.env');

// Configuration Constants
define('SITE_NAME', $_ENV['SITE_NAME'] ?? 'VectorShop');
define('SITE_URL', $_ENV['SITE_URL'] ?? 'http://localhost');
define('ADMIN_EMAIL', $_ENV['ADMIN_EMAIL'] ?? 'admin@localhost');

// Database
define('DB_PATH', __DIR__ . '/../' . ($_ENV['DB_PATH'] ?? 'data/vectorshop.db'));

// Admin Credentials
define('ADMIN_USERNAME', $_ENV['ADMIN_USERNAME'] ?? 'admin');
define('ADMIN_PASSWORD', $_ENV['ADMIN_PASSWORD'] ?? 'admin123');

// Paddle
define('PADDLE_VENDOR_ID', $_ENV['PADDLE_VENDOR_ID'] ?? '');
define('PADDLE_API_KEY', $_ENV['PADDLE_API_KEY'] ?? '');
define('PADDLE_PUBLIC_KEY', $_ENV['PADDLE_PUBLIC_KEY'] ?? '');
define('PADDLE_SHARED_SECRET', $_ENV['PADDLE_SHARED_SECRET'] ?? '');

// GitHub
define('GITHUB_TOKEN', $_ENV['GITHUB_TOKEN'] ?? '');
define('GITHUB_REPO', $_ENV['GITHUB_REPO'] ?? '');

// SMTP
define('SMTP_HOST', $_ENV['SMTP_HOST'] ?? 'smtp.gmail.com');
define('SMTP_PORT', $_ENV['SMTP_PORT'] ?? 587);
define('SMTP_USERNAME', $_ENV['SMTP_USERNAME'] ?? '');
define('SMTP_PASSWORD', $_ENV['SMTP_PASSWORD'] ?? '');
define('SMTP_FROM_EMAIL', $_ENV['SMTP_FROM_EMAIL'] ?? 'noreply@localhost');
define('SMTP_FROM_NAME', $_ENV['SMTP_FROM_NAME'] ?? 'VectorShop');

// Security
define('SESSION_SECRET', $_ENV['SESSION_SECRET'] ?? 'change-this-secret');
define('ENCRYPTION_KEY', $_ENV['ENCRYPTION_KEY'] ?? 'change-this-32-char-key-please');

// Debug
define('DEBUG_MODE', ($_ENV['DEBUG_MODE'] ?? 'false') === 'true');

// Error Reporting
if (DEBUG_MODE) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// Session
session_start();

// Timezone
date_default_timezone_set('Europe/Istanbul');
?>
