<?php
require_once '../includes/config.php';
require_once '../includes/utils.php';

if (isLoggedIn()) {
    redirect('/admin/dashboard.php');
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = sanitize($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if ($username === ADMIN_USERNAME && $password === ADMIN_PASSWORD) {
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_username'] = $username;
        logMessage("Admin logged in: $username");
        redirect('/admin/dashboard.php');
    } else {
        $error = 'Invalid username or password';
        logMessage("Failed login attempt for: $username", 'WARNING');
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
    <div class="admin-login">
        <div class="login-box">
            <h1>Admin Login</h1>
            
            <?php if ($error): ?>
                <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <div class="form-group">
                    <label>Username:</label>
                    <input type="text" name="username" required autofocus>
                </div>
                
                <div class="form-group">
                    <label>Password:</label>
                    <input type="password" name="password" required>
                </div>
                
                <button type="submit" class="btn btn-block btn-large">Login</button>
            </form>
            
            <div style="text-align: center; margin-top: 1.5rem;">
                <a href="/" style="color: #667eea; text-decoration: none;">← Back to Site</a>
            </div>
        </div>
    </div>
</body>
</html>
