# Vector Shop - Dijital Ürün Satış Platformu

Flask tabanlı güvenli dijital ürün satış sistemi. Paddle ödeme entegrasyonu ve GitHub Releases üzerinden şifreli dosya teslimatı.

## Özellikler

- **Güvenli Ödeme**: Paddle entegrasyonu ile güvenli ödeme işlemleri
- **Şifreli Teslimat**: AES-256 ile şifrelenmiş dosyalar
- **Parçalı İndirme**: Büyük dosyalar otomatik olarak parçalanır
- **GitHub Storage**: Dosyalar GitHub Releases üzerinde saklanır (sunucuda depolama yok)
- **Admin Panel**: Ürün, kupon ve sipariş yönetimi
- **Log Sistemi**: Tüm işlemler günlük dosyalarına kaydedilir
- **E-posta Bildirimleri**: Otomatik teslimat e-postaları
- **CSV Import**: Toplu ürün ekleme (veri.csv formatı desteklenir)
- **Görsel Entegrasyonu**: Adobe Stock ve diğer kaynaklardan direkt görsel URL'leri

## Kurulum

### 1. Gereksinimleri Yükleyin

```bash
cd vector-shop
python -m venv venv
.\venv\Scripts\activate  # Windows
source venv/bin/activate  # Linux/Mac
pip install -r requirements.txt
```

### 2. Ortam Değişkenlerini Ayarlayın

`env.example` dosyasını `.env` olarak kopyalayın ve gerekli değerleri doldurun:

```bash
copy env.example .env  # Windows
cp env.example .env    # Linux/Mac
```

`.env` dosyasını düzenleyin:

```env
FLASK_SECRET_KEY=rastgele-güvenli-anahtar-buraya
PADDLE_VENDOR_ID=paddle-vendor-id
PADDLE_API_KEY=paddle-api-key
PADDLE_PUBLIC_KEY=paddle-public-key
PADDLE_SHARED_SECRET=paddle-webhook-secret
GITHUB_TOKEN=github-personal-access-token
GITHUB_REPO=kullaniciadi/repository-adi
ADMIN_USERNAME=admin
ADMIN_PASSWORD=güçlü-şifre
SMTP_SERVER=smtp.gmail.com
SMTP_PORT=587
SMTP_USERNAME=email@gmail.com
SMTP_PASSWORD=email-şifresi
FROM_EMAIL=email@gmail.com
```

### 3. Veritabanını Oluşturun ve veri.csv Dosyasını Import Edin

```bash
# Veritabanı tablolarını oluştur
python -c "from app import app, db; app.app_context().push(); db.create_all(); print('Veritabanı oluşturuldu!')"

# veri.csv dosyasını import et (3000+ ürün)
python import_veri.py
```

**veri.csv Format:**
```
id|title|description|price|image|category|tags|keywords|popular|permanentlink|customers
1|Stock id:1747046661|Açıklama...|3.00|https://...|vectors|tag1,tag2|keyword1,keyword2|true|https://...|customer1,customer2
```

### 4. Paddle Hesabı Kurulumu

1. [Paddle.com](https://paddle.com) hesabı oluşturun
2. **Products** bölümünden dijital ürünler oluşturun
3. **Developer Tools** → **Webhooks**:
   - Webhook URL: `https://your-domain.com/webhook/paddle`
   - Shared Secret'i kopyalayın ve `.env`'ye ekleyin
4. Her ürün için Product ID'yi not alın

### 5. GitHub Repository Kurulumu

1. Private bir repository oluşturun
2. **Settings** → **Developer settings** → **Personal access tokens**
3. Yeni token oluşturun (repo, write:packages izinleri)
4. Token'ı `.env` dosyasına ekleyin

### 6. Uygulamayı Çalıştırın

```bash
python app.py
```

Uygulama `http://localhost:5000` adresinde çalışacaktır.

## Cloudflare Tunnel ile Yayınlama

### 1. Cloudflare Tunnel Kurulumu

```powershell
# Cloudflared'i indirin
# Windows için: https://github.com/cloudflare/cloudflared/releases

# Giriş yapın
cloudflared tunnel login

# Tunnel oluşturun
cloudflared tunnel create vector-shop

# Tunnel'ı yapılandırın
cloudflared tunnel route dns vector-shop your-domain.com
```

### 2. Tunnel Config Dosyası

`config.yml` dosyası oluşturun:

```yaml
tunnel: <tunnel-id>
credentials-file: C:\Users\YourUser\.cloudflared\<tunnel-id>.json

ingress:
  - hostname: your-domain.com
    service: http://localhost:5000
  - service: http_status:404
```

### 3. Tunnel'ı Başlatın

```powershell
cloudflared tunnel --config config.yml run vector-shop
```

## Kullanım

### Admin Paneli

1. `http://your-domain.com/admin/login` adresine gidin
2. `.env` dosyasındaki kullanıcı adı ve şifre ile giriş yapın
3. Admin panelinde yapabilecekleriniz:
   - Yeni ürün ekleme
   - CSV ile toplu ürün yükleme (veri.csv formatı)
   - Kupon kodu oluşturma
   - Siparişleri görüntüleme
   - Sistem loglarını inceleme

### veri.csv Formatında Ürün Import

**Manuel (Web Üzerinden):**
1. Admin panelinde "CSV ile Toplu Ürün Ekle" bölümüne gidin
2. veri.csv dosyasını seçin (pipe | ile ayrılmış format)
3. "İçe Aktar" butonuna tıklayın

**Otomatik (Script ile):**
```bash
# veri.csv dosyasını proje klasörüne koyun
python import_veri.py
```

Script özellikleri:
- Var olan ürünleri günceller (csv_id'ye göre)
- Yeni ürünleri ekler
- Her 500 kayıtta bir veritabanına commit
- İlerleme durumu gösterir
- Hata logları

### Sipariş Akışı

1. Müşteri ürünü seçer ve "Satın Al" butonuna tıklar
2. Paddle ödeme sayfasına yönlendirilir
3. Ödeme tamamlandığında Paddle webhook gönderir
4. Sistem otomatik olarak:
   - Siparişi veritabanına kaydeder
   - GitHub'dan download linklerini alır
   - Müşteriye şifre ve linkleri e-posta ile gönderir
5. Müşteri e-postadaki linklerden dosyaları indirir
6. WinRAR/7-Zip ile birleştirir ve şifreyi girer

## Proje Yapısı

```
vector-shop/
├── app.py                 # Ana Flask uygulaması
├── models.py              # Veritabanı modelleri (güncellenmiş)
├── paddle_webhook.py      # Paddle webhook işleyici
├── import_veri.py         # veri.csv otomatik import scripti
├── requirements.txt       # Python bağımlılıkları
├── veri.csv              # Ürün veritabanı (3000+ ürün)
├── .env                  # Ortam değişkenleri
├── .gitignore           # Git ignore kuralları
├── utils/
│   ├── __init__.py
│   ├── zip_encrypt.py    # Dosya şifreleme ve bölme
│   └── file_delivery.py  # GitHub teslimat modülü
├── templates/
│   ├── index.html        # Ana sayfa
│   ├── product.html      # Ürün detay
│   ├── success.html      # Başarılı ödeme
│   ├── admin.html        # Admin paneli
│   ├── admin_login.html  # Admin girişi
│   └── logs.html         # Log görüntüleyici
├── static/
│   └── style.css         # CSS stilleri
└── logs/
    └── .gitkeep          # Log dosyaları
```

## Veritabanı Şeması (Güncellenmiş)

### Product Modeli
```python
- id (Primary Key)
- csv_id (CSV dosyasındaki ID)
- name (Ürün adı / title)
- description (Açıklama)
- price (Fiyat)
- image_url (Görsel URL - Adobe Stock vb.)
- category (Kategori: vectors, graphics, illustrations)
- tags (Etiketler)
- keywords (Anahtar kelimeler)
- popular (Popüler mi? boolean)
- permanentlink (Kalıcı link)
- paddle_product_id (Paddle ürün ID)
- github_release_tag (GitHub release tag)
- file_parts_count (Dosya parça sayısı)
- active (Aktif mi?)
- created_at (Oluşturma tarihi)
```

## Güvenlik Notları

- `.env` dosyasını asla paylaşmayın veya Git'e commit etmeyin
- Güçlü admin şifresi kullanın
- SMTP şifresi için app-specific password kullanın
- GitHub token'ının minimum gerekli izinlere sahip olduğundan emin olun
- HTTPS kullanın (Cloudflare Tunnel otomatik sağlar)
- Düzenli olarak logları kontrol edin

## Sorun Giderme

### E-postalar Gönderilmiyor
- SMTP ayarlarını kontrol edin
- Gmail kullanıyorsanız "App Password" oluşturun
- Firewall/antivirus SMTP portunu engelliyor olabilir

### Webhook Çalışmıyor
- Paddle Shared Secret doğru mu kontrol edin
- Webhook URL'sinin doğru olduğundan emin olun
- Logları kontrol edin: `/admin/logs`

### veri.csv Import Hatası
- Dosyanın UTF-8 encoding'de olduğundan emin olun
- Pipe `|` karakterinin doğru kullanıldığını kontrol edin
- `import_veri.py` çıktısındaki hata mesajlarını inceleyin

### GitHub Upload Hatası
- Token izinlerini kontrol edin
- Repository adının doğru olduğundan emin olun
- Release tag'leri benzersiz olmalı

## Lisans

Bu proje MIT lisansı altında lisanslanmıştır.

## Destek

Sorun yaşıyorsanız:
1. Log dosyalarını kontrol edin: `logs/YYYY-MM-DD.txt`
2. Admin panelinden sistem durumunu inceleyin
3. GitHub Issues'da sorun bildirin

---

**Not**: veri.csv dosyası 3000+ ürün içermektedir ve Adobe Stock görsellerini kullanmaktadır.
