<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>URL İndeksleme Kontrolü</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 8px;
            text-align: center;
        }
        .check-icon {
            color: green;
            font-weight: bold;
        }
        .not-indexed {
            color: red;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <h1>URL İndeksleme Kontrolü</h1>
    <form method="post" action="">
        <label for="urls">Kontrol etmek istediğiniz URL'leri girin (her biri yeni satıra):</label><br>
        <textarea id="urls" name="urls" rows="10" cols="50"></textarea><br><br>
        <input type="submit" value="Kontrol Et">
    </form>

    <?php
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $urls = explode("\n", $_POST['urls']);
        echo "<table>";
        echo "<tr><th>URL</th><th>Google</th><th>Bing</th><th>Yandex</th></tr>";
        
        foreach ($urls as $url) {
            $url = trim($url);
            if (!empty($url)) {
                echo "<tr><td>{$url}</td>";
                echo "<td>" . (isIndexedBySearchEngine($url, 'google') ? "<span class='check-icon'>&#10004;</span> Başarılı" : "<span class='not-indexed'>Henüz indekslenmemiş</span>") . "</td>";
                echo "<td>" . (isIndexedBySearchEngine($url, 'bing') ? "<span class='check-icon'>&#10004;</span> Başarılı" : "<span class='not-indexed'>Henüz indekslenmemiş</span>") . "</td>";
                echo "<td>" . (isIndexedBySearchEngine($url, 'yandex') ? "<span class='check-icon'>&#10004;</span> Başarılı" : "<span class='not-indexed'>Henüz indekslenmemiş</span>") . "</td>";
                echo "</tr>";
            }
        }

        echo "</table>";
    }

    function isIndexedBySearchEngine($url, $engine) {
        $query = urlencode($url);
        switch ($engine) {
            case 'google':
                $searchUrl = "https://www.google.com/search?q={$query}";
                break;
            case 'bing':
                $searchUrl = "https://www.bing.com/search?q={$query}";
                break;
            case 'yandex':
                $searchUrl = "https://yandex.com/search/?text={$query}";
                break;
            default:
                return false;
        }
        
        $response = @file_get_contents($searchUrl);
        return $response && strpos($response, $url) !== false;
    }
    ?>
</body>
</html>
